;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Tracking Flame, by Koopster
;
;a flame that will track Mario's position once and fly in his direction, in a way analogous to
;Magikoopa's magic or Reznor's fireballs, except this uses a proper speed calculation and also
;accounts for Mario's small hitbox.
;
;it is meant to be spawned by a shooter, but nothing stops you from placing this directly.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;settings
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;tilemap. refer to .json for palette (default = A) and graphics page (default = second)

	!Tiles = $EC,$EE

;flame speed

	!Speed = $20

;sound effect configurations when the flame starts moving

	!Sound = 1			;0 = no sfx when thrown, 1 = sfx when thrown
	!SFX = $27			;sfx id
	!SFXBank = $1DFC	;sfx bank (https://smwc.me/t/6665)

;how many frames to wait before the flame starts moving

	!Wait = $40

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;settings end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;init
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

print "INIT ",pc
	LDA #!Wait		;\
	STA !15AC,x		;/set status timer

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;main
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;main header
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

print "MAIN ",pc
	PHB : PHK : PLB
	JSR Run
	PLB : RTL

Run:
	LDA #$00
	%SubOffScreen()
	
+	JSR Graphics
	
	LDA !14C8,x
	EOR #$08		;return if sprite is not alive
	ORA $9D			;return if game is frozen
	BEQ NotDead
	RTS

Poof:
	LDA #$02		;\
	STA !14C8,x		;/set dead status
	RTS

NotDead:

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;position and interaction routines
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	;update positions
	JSL $01801A|!BankB	;update x
	JSL $018022|!BankB	;update y
	
	;simplified Mario interaction (always hurt on touch)
	JSL $01A7DC|!BankB	;check whether Mario is touching the sprite
	BCC NoHurt			;branch if no contact
	LDA $1490|!Base2
	BNE Poof			;make sprite poof if player has a star
	LDA $187A|!Base2
	BEQ NoYoshi			;branch if not riding yoshi
	
	;handle yoshi interaction
	LDX #!SprSize-1		;\
-	LDA !9E,x			;|
	CMP #$35			;|loop to find yoshi's slot (sprite 35), store in x
	BEQ +				;|
	DEX					;|
	BPL -				;/
	
+	PEA $01|(PushReturn>>16<<8)	;asar math is literally harder than asm
	PLB							;push $01 to data bank register temporarily
	
	PHK					;\
	PEA PushReturn-1	;|
	PEA $80CA-1			;|jslrts to yoshi runs away routine to force it to happen
	JML $01F713|!BankB	;|
PushReturn:				;/
	
	PLB					;restore our data bank register
	LDX $15E9|!Base2	;restore sprite index
	
NoYoshi:	
	JSL $00F5B7|!Base2	;hurt Mario, won't matter if yoshi routine has run since he's flashing
	
NoHurt:

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;animation
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	LDA !1540,x
	BNE +
	LDA #$10		;\
	STA !1540,x		;/reset timer every 16 frames
+	LSR #3			;\
	AND #$01		;|
	STA !1602,x		;/store high bit to current frame

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;sprite states
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	LDA !C2,x
	BNE Return

;$00 = waiting for initial timer to run out, get Mario's position

	LDA !15AC,x
	BNE Return		;return if initial timer hasn't expired yet
	
	INC !C2,x		;increase sprite state otherwise
	
	LDA !B6,x		;\
	BNE Return		;|
	LDA !AA,x		;|
	BNE Return		;/return if sprite is already moving (been twhacked)
	
	if !Sound
		LDA #!SFX			;\
		STA !SFXBank|!Base2	;/play sfx
	endif
	
	;aim at Mario
	LDA !14E0,x		;\
	XBA				;|
	LDA !E4,x		;/sprite xpos
	REP #$20
	SEC
	SBC $94			;subtract from Mario xpos
	STA $00			;$00 = Mario - sprite x offset (16-bit)
	SEP #$20
	
	LDA !14D4,x		;\
	XBA				;|
	LDA !D8,x		;/sprite ypos
	SEC
	REP #$20
	LDY $19			;\
	BEQ +			;/if Mario is small
	LDY $73			;\
	BEQ ++			;/or otherwise not small and ducking
+	SBC #$0010		;/offset his tracked ypos by a tile
++	SBC $96			;subtract from Mario ypos
	STA $02			;$02 = Mario - sprite y offset (16-bit)
	SEP #$20
	LDA #!Speed
	
	%Aiming()		;great work with this one, MarioE!
	
	LDA $00
	STA !B6,x		;set x speed
	LDA $02
	STA !AA,x		;set y speed

;$01 = flying off

	;oof this state was tough
	
Return:
	RTS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;graphics routine
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

Tilemap:
	db !Tiles

Graphics:
	%GetDrawInfo()
	
	LDA $00
	STA $0300|!Base2,y	;xpos
	
	LDA $01
	STA $0301|!Base2,y	;ypos
	
	LDA !1602,x			;\
	TAX					;/get current frame as index
	LDA Tilemap,x
	STA $0302|!Base2,y	;tilemap
	LDX $15E9|!Base2	;restore sprite number
	
	LDA !15F6,x			;get .json properties
	ORA $64
	STA $0303|!Base2,y	;properties
	
	LDY #$02			;16x16
	LDA #$00			;1 tile
	JSL $01B7B3|!BankB	;finish oam
	
	RTS 